CREATE DATABASE AgencjaArtystycznaPrzyklad
GO

use AgencjaArtystycznaPrzyklad
GO

CREATE TABLE Agenci (
	IDAgenta int NOT NULL ,
	ImieAgenta nvarchar (25) NULL ,
	NazwiskoAgenta nvarchar (25) NULL ,
	AdresAgenta nvarchar (50) NULL ,
	MiastoAgenta nvarchar (30) NULL ,
	StanZamAgenta nvarchar (2) NULL ,
	KodPocztowyAgenta nvarchar (10) NULL ,
	TelefonAgenta nvarchar (15) NULL ,
	DataZatrudnienia date NULL ,
	Wynagrodzenie money NULL ,
	Premia float(24) NULL
)
GO

CREATE TABLE Klienci (
	IDKlienta int NOT NULL ,
	ImieKlienta nvarchar (25) NULL ,
	NazwiskoKlienta nvarchar (25) NULL ,
	AdresKlienta nvarchar (50) NULL ,
	MiastoKlienta nvarchar (30) NULL ,
	StanZamKlienta nvarchar (2) NULL ,
	KodPocztowyKlienta nvarchar (10) NULL ,
	TelefonKlienta nvarchar (15) NULL 
)
GO

CREATE TABLE Imprezy (
	NumerImprezy int NOT NULL ,
	DzienRozpoczecia date NULL ,
	DzienZakonczenia date NULL ,
	GodzinaRozpoczecia time NULL ,
	GodzinaZakonczenia time NULL ,
	WartoscKontraktu money NULL ,
	IDKlienta int NULL ,
	IDAgenta int NULL ,
	IDWykonawcy int NULL 
)
GO

CREATE TABLE Czlonkowie_zespolu (
	IDWykonawcy int NOT NULL ,
	IDCzlonka int NOT NULL ,
	Status smallint NULL 
)
GO

CREATE TABLE Style_wykonawcow (
	IDWykonawcy int NOT NULL ,
	IDStylu smallint NOT NULL , 
        WplywStylu smallint NOT NULL 
)
GO

CREATE TABLE Wykonawcy (
	IDWykonawcy int NOT NULL ,
	NazwaScenicznaWykonawcy nvarchar (50) NULL ,
	NrUbezpWykonawcy nvarchar (12) NULL ,
	AdresWykonawcy nvarchar (50) NULL ,
	MiastoWykonawcy nvarchar (30) NULL ,
	StanZamWykonawcy nvarchar (2) NULL ,
	KodPocztowyWykonawcy nvarchar (10) NULL ,
	TelefonWykonawcy nvarchar (15) NULL ,
	StronaInterWykonawcy nvarchar (50) NULL ,
	EmailWykonawcy nvarchar (50) NULL ,
	DataRejestracji date NULL 
)
GO

CREATE TABLE Czlonkowie (
	IDCzlonka int NOT NULL ,
	ImieCzlonka nvarchar (25) NULL ,
	NazwiskoCzlonka nvarchar (25) NULL ,
	TelefonCzlonka nvarchar (15) NULL ,
	Plec nvarchar (2) NULL 
)
GO

CREATE TABLE Gusty_muzyczne (
	IDKlienta int NOT NULL ,
	IDStylu smallint NOT NULL ,
        KolejnoscPreferencji smallint NOT NULL 
)
GO

CREATE TABLE Style_muzyczne (
	IDStylu smallint NOT NULL ,
	NazwaStylu nvarchar (75) NULL 
)
GO

CREATE TABLE ztblDni (
        PoleDaty date NOT NULL 
)
GO

CREATE TABLE ztblMiesiace ( 
        MiesiacRok nvarchar (20) NULL ,
        NumerRoku smallint NOT NULL ,
        NumerMiesiaca smallint NOT NULL ,
        PoczatekMiesiaca date NULL ,
        KoniecMiesiaca date NULL ,
        Styczen smallint NULL ,
        Luty smallint NULL ,
        Marzec smallint NULL ,
        Kwiecien smallint NULL ,
        Maj smallint NULL ,
        Czerwiec smallint NULL ,
        Lipiec smallint NULL ,
        Sierpien smallint NULL ,
        Wrzesien smallint NULL ,
        Pazdziernik smallint NULL ,
        Listopad smallint NULL ,
        Grudzien smallint NULL 
)
GO

CREATE TABLE ztblPomijanieEtykiet (
        LicznikEtykiet int NOT NULL  
)
GO

CREATE TABLE ztblTygodnie ( 
        PoczatekTygodnia date NOT NULL ,
        KoniecTygodnia date NULL 
)
GO

ALTER TABLE Agenci ADD 
	CONSTRAINT Salary_Default DEFAULT (0) FOR Wynagrodzenie,
	CONSTRAINT Commission_Rate_Default DEFAULT (0) FOR Premia,
	CONSTRAINT Agenci_PK PRIMARY KEY   
	(
		IDAgenta
	)  
GO

 CREATE  INDEX KodPocztowyAgenta ON Agenci(KodPocztowyAgenta)
GO

ALTER TABLE Klienci ADD 
	CONSTRAINT Klienci_PK PRIMARY KEY   
	(
		IDKlienta
	)  
GO

 CREATE  INDEX KodPocztowyKlienta ON Klienci(KodPocztowyKlienta)
GO

ALTER TABLE Imprezy ADD 
	CONSTRAINT Engagement_Number_Default DEFAULT (0) FOR NumerImprezy,
	CONSTRAINT Contract_Price_Default DEFAULT (0) FOR WartoscKontraktu,
	CONSTRAINT Customer_ID_Default DEFAULT (0) FOR IDKlienta,
	CONSTRAINT EN_Agent_ID_Default DEFAULT (0) FOR IDAgenta,
	CONSTRAINT EN_Wykonawca_ID_Default DEFAULT (0) FOR IDWykonawcy,
	CONSTRAINT Imprezy_PK PRIMARY KEY   
	(
		NumerImprezy
	)  
GO

 CREATE  INDEX AgenciImprezy ON Imprezy(IDAgenta)
GO

 CREATE  INDEX KlienciImprezy ON Imprezy(IDKlienta)
GO

 CREATE  INDEX WykonawcyImprezy ON Imprezy(IDWykonawcy)
GO

ALTER TABLE Czlonkowie_zespolu ADD 
	CONSTRAINT EM_Member_ID_Default DEFAULT (0) FOR IDCzlonka,
	CONSTRAINT EM_Status_Default DEFAULT (0) FOR Status,
	CONSTRAINT Czlonkowie_zespolu_PK PRIMARY KEY   
	(
		IDWykonawcy,
		IDCzlonka
	)  
GO

 CREATE  INDEX WykonawcyWykonawcaCzlonkowie ON Czlonkowie_zespolu(IDWykonawcy)
GO

 CREATE  INDEX CzlonkowieWykonawcaCzlonkowie ON Czlonkowie_zespolu(IDCzlonka)
GO

ALTER TABLE Style_wykonawcow ADD 
	CONSTRAINT EN_Styles_Default DEFAULT (0) FOR IDStylu,
	CONSTRAINT Style_wykonawcow_PK PRIMARY KEY   
	(
		IDWykonawcy,
		IDStylu
	)  
GO

 CREATE  INDEX WykonawcyWykonawcaStyles ON Style_wykonawcow(IDWykonawcy)
GO

 CREATE  INDEX StyleMuzyczneStyleWyk ON Style_wykonawcow(IDStylu)
GO

ALTER TABLE Wykonawcy ADD 
	CONSTRAINT Wykonawcy_PK PRIMARY KEY   
	(
		IDWykonawcy
	)  
GO

 CREATE  UNIQUE  INDEX IDWykonawcy ON Wykonawcy(IDWykonawcy)
GO

 CREATE  INDEX KodPocztowyWykonawcy ON Wykonawcy(KodPocztowyWykonawcy)
GO

ALTER TABLE Czlonkowie ADD 
	CONSTRAINT Member_ID_Default DEFAULT (0) FOR IDCzlonka,
	CONSTRAINT Czlonkowie_PK PRIMARY KEY   
	(
		IDCzlonka
	)  
GO

 CREATE  INDEX IDCzlonka ON Czlonkowie(IDCzlonka)
GO

ALTER TABLE Gusty_muzyczne ADD 
	CONSTRAINT MP_Customer_ID_Default DEFAULT (0) FOR IDKlienta,
	CONSTRAINT MP_Style_ID_Default DEFAULT (0) FOR IDStylu,
	CONSTRAINT Gusty_muzyczne_PK PRIMARY KEY   
	(
		IDKlienta,
		IDStylu
	)  
GO

 CREATE  INDEX KlienciMuzykaalPreferences ON Gusty_muzyczne(IDKlienta)
GO

 CREATE  INDEX IDStylu ON Gusty_muzyczne(IDStylu)
GO

ALTER TABLE Style_muzyczne ADD 
	CONSTRAINT MS_Style_ID_Default DEFAULT (0) FOR IDStylu,
	CONSTRAINT Style_muzyczne_PK PRIMARY KEY   
	(
		IDStylu
	)  
GO

ALTER TABLE ztblDni ADD 
        CONSTRAINT ztblDni_PK PRIMARY KEY 
        ( 
                PoleDaty 
        )
GO

ALTER TABLE ztblMiesiace ADD 
        CONSTRAINT Styczen_Default DEFAULT (0) FOR Styczen, 
        CONSTRAINT Luty_Default DEFAULT (0) FOR Luty, 
        CONSTRAINT Marzec_Default DEFAULT (0) FOR Marzec, 
        CONSTRAINT Kwiecien_Default DEFAULT (0) FOR Kwiecien, 
        CONSTRAINT Maj_Default DEFAULT (0) FOR Maj, 
        CONSTRAINT Czerwiec_Default DEFAULT (0) FOR Czerwiec, 
        CONSTRAINT Lipiec_Default DEFAULT (0) FOR Lipiec, 
        CONSTRAINT Sierpien_Default DEFAULT (0) FOR Sierpien, 
        CONSTRAINT Wrzesien_Default DEFAULT (0) FOR Wrzesien, 
        CONSTRAINT Pazdziernik_Default DEFAULT (0) FOR Pazdziernik, 
        CONSTRAINT Listopad_Default DEFAULT (0) FOR Listopad, 
        CONSTRAINT Grudzien_Default DEFAULT (0) FOR Grudzien, 
        CONSTRAINT ztblMiesiace_PK PRIMARY KEY 
        ( 
                NumerRoku, 
                NumerMiesiaca
        )
GO

 CREATE UNIQUE INDEX ztblMiesiace_KoniecMiesiaca ON ztblMiesiace(KoniecMiesiaca) 
GO

 CREATE UNIQUE INDEX ztblMiesiace_PoczatekMiesiaca ON ztblMiesiace(PoczatekMiesiaca) 
GO

 CREATE UNIQUE INDEX ztblMiesiace_MiesiacRok ON ztblMiesiace(MiesiacRok) 
GO

ALTER TABLE ztblPomijanieEtykiet ADD 
        CONSTRAINT ztblPomijanieEtykiet_PK PRIMARY KEY 
        (
                LicznikEtykiet 
        ) 
GO

ALTER TABLE ztblTygodnie ADD 
        CONSTRAINT ztblTygodnie_PK PRIMARY KEY 
        ( 
                PoczatekTygodnia 
        ) 
GO

ALTER TABLE Imprezy ADD 
	CONSTRAINT Imprezy_FK00 FOREIGN KEY 
	(
		IDAgenta
	) REFERENCES Agenci (
		IDAgenta
	),
	CONSTRAINT Imprezy_FK01 FOREIGN KEY 
	(
		IDKlienta
	) REFERENCES Klienci (
		IDKlienta
	),
	CONSTRAINT Imprezy_FK02 FOREIGN KEY 
	(
		IDWykonawcy
	) REFERENCES Wykonawcy (
		IDWykonawcy
	)
GO

ALTER TABLE Czlonkowie_zespolu ADD 
	CONSTRAINT Czlonkowie_zespolu_FK00 FOREIGN KEY 
	(
		IDWykonawcy
	) REFERENCES Wykonawcy (
		IDWykonawcy
	),
	CONSTRAINT Czlonkowie_zespolu_FK01 FOREIGN KEY 
	(
		IDCzlonka
	) REFERENCES Czlonkowie (
		IDCzlonka
	)
GO

ALTER TABLE Style_wykonawcow ADD 
	CONSTRAINT Style_wykonawcow_FK00 FOREIGN KEY 
	(
		IDWykonawcy
	) REFERENCES Wykonawcy (
		IDWykonawcy
	),
	CONSTRAINT Style_wykonawcow_FK01 FOREIGN KEY 
	(
		IDStylu
	) REFERENCES Style_muzyczne (
		IDStylu
	)
GO

ALTER TABLE Gusty_muzyczne ADD 
	CONSTRAINT Gusty_muzyczne_FK00 FOREIGN KEY 
	(
		IDKlienta
	) REFERENCES Klienci (
		IDKlienta
	),
	CONSTRAINT Gusty_muzyczne_FK01 FOREIGN KEY 
	(
		IDStylu
	) REFERENCES Style_muzyczne (
		IDStylu
	)
GO


